/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.util.JSONDynaBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class JSONDynaClass
implements DynaClass,
Serializable {
    private static final Comparator dynaPropertyComparator = new Comparator(){

        public int compare(Object a, Object b) {
            if (a instanceof DynaProperty && b instanceof DynaProperty) {
                DynaProperty p1 = (DynaProperty)a;
                DynaProperty p2 = (DynaProperty)b;
                return p1.getName().compareTo(p2.getName());
            }
            return -1;
        }
    };
    private static final long serialVersionUID = 7621696882809002180L;
    protected Map attributes;
    protected DynaProperty[] dynaProperties;
    protected Class jsonBeanClass;
    protected String name;
    protected Map properties = new HashMap();
    protected Class type;
    static /* synthetic */ Class class$net$sf$json$util$JSONDynaBean;

    public JSONDynaClass(String name, Class type, Map attributes) {
        this.name = name;
        this.type = type;
        this.attributes = attributes;
        this.process();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONDynaClass)) {
            return false;
        }
        JSONDynaClass other = (JSONDynaClass)obj;
        EqualsBuilder builder = new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.type, (Object)other.type);
        if (this.dynaProperties.length != other.dynaProperties.length) {
            return false;
        }
        for (int i = 0; i < this.dynaProperties.length; ++i) {
            DynaProperty a = this.dynaProperties[i];
            DynaProperty b = other.dynaProperties[i];
            builder.append((Object)a.getName(), (Object)b.getName());
            builder.append((Object)a.getType(), (Object)b.getType());
        }
        return builder.isEquals();
    }

    public DynaProperty[] getDynaProperties() {
        return this.dynaProperties;
    }

    public DynaProperty getDynaProperty(String propertyName) {
        if (propertyName == null) {
            throw new JSONException("Unnespecified bean property name");
        }
        return (DynaProperty)this.properties.get(propertyName);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)this.name).append((Object)this.type);
        for (int i = 0; i < this.dynaProperties.length; ++i) {
            builder.append((Object)this.dynaProperties[i].getName());
            builder.append((Object)this.dynaProperties[i].getType());
        }
        return builder.toHashCode();
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        JSONDynaBean dynaBean = (JSONDynaBean)this.getJsonBeanClass().newInstance();
        dynaBean.setDynaBeanClass(this);
        Iterator keys = this.attributes.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            dynaBean.set(key, null);
        }
        return dynaBean;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("type", (Object)this.type).append("attributes", (Object)this.attributes).toString();
    }

    protected Class getJsonBeanClass() {
        if (this.jsonBeanClass == null) {
            this.process();
        }
        return this.jsonBeanClass;
    }

    private void process() {
        this.jsonBeanClass = this.type;
        if (!(class$net$sf$json$util$JSONDynaBean == null ? (class$net$sf$json$util$JSONDynaBean = JSONDynaClass.class$("net.sf.json.util.JSONDynaBean")) : class$net$sf$json$util$JSONDynaBean).isAssignableFrom(this.jsonBeanClass)) {
            throw new JSONException("Unnasignable dynaClass " + this.jsonBeanClass);
        }
        try {
            Iterator entries = this.attributes.entrySet().iterator();
            this.dynaProperties = new DynaProperty[this.attributes.size()];
            int i = 0;
            while (entries.hasNext()) {
                Class klass;
                Map.Entry entry = entries.next();
                String pname = (String)entry.getKey();
                Object pclass = entry.getValue();
                DynaProperty dynaProperty = null;
                if (pclass instanceof String) {
                    klass = Class.forName((String)pclass);
                    if (klass.isArray() && klass.getComponentType().isArray()) {
                        throw new JSONException("Multidimensional arrays are not supported");
                    }
                    dynaProperty = new DynaProperty(pname, klass);
                } else if (pclass instanceof Class) {
                    klass = (Class)pclass;
                    if (klass.isArray() && klass.getComponentType().isArray()) {
                        throw new JSONException("Multidimensional arrays are not supported");
                    }
                    dynaProperty = new DynaProperty(pname, klass);
                } else {
                    throw new JSONException("Type must be String or Class");
                }
                this.properties.put(dynaProperty.getName(), dynaProperty);
                this.dynaProperties[i++] = dynaProperty;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new JSONException(cnfe);
        }
        Arrays.sort(this.dynaProperties, 0, this.dynaProperties.length, dynaPropertyComparator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

